package myBean;

import org.apache.poi.hssf.usermodel.*;
import java.io.FileOutputStream;
import java.io.*;
import java.sql.*;
import myBean.DBConnection;

public class POIExcel {
	private DBConnection con;
	
	public POIExcel() {
		con = new DBConnection();
	}
	
	public void exportExcel(String name, OutputStream out) {
		HSSFWorkbook wb = new HSSFWorkbook();
		HSSFSheet sheet = wb.createSheet(name);
		
		HSSFRow row = sheet.createRow(0);
		HSSFCell cell = row.createCell((short)0);
		cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		cell.setCellValue("");
		
		cell = row.createCell((short)1);
		cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		cell.setCellValue("ʼ");
		
		String sql = "select name, email from users";
		int nRow=1;
		try {
			ResultSet rs = con.execQuery(sql);
			while(rs.next()) {
				row = sheet.createRow(nRow++);
				cell = row.createCell((short)0);
				cell.setEncoding(HSSFCell.ENCODING_UTF_16);
				cell.setCellValue(rs.getString("name"));
				
				cell = row.createCell((short)1);
				cell.setEncoding(HSSFCell.ENCODING_UTF_16);
				cell.setCellValue(rs.getString("email"));
			}
			rs.close();
		}catch(SQLException e) {
			System.err.println("POIExcel.exportExcel()" + e.getMessage());
		}
		
		
		try {
			wb.write(out);
		}catch(Exception e) {
			System.err.println("POIExcel.exportExcel()" + e.getMessage());
		}
	}
/*	
	public static void main(String args[]) {
		try {
			FileOutputStream os = new FileOutputStream("poitest.xls");
			new POIExcel().exportExcel("user", os);
			os.close();
		}catch (IOException e) {
		}
	}
*/
}